/*
 * Decompiled with CFR 0.152.
 */
package c4.corpsecomplex.common.modules.inventory;

import c4.corpsecomplex.common.modules.inventory.InventoryModule;
import c4.corpsecomplex.common.modules.inventory.capability.IDeathInventory;
import c4.corpsecomplex.common.modules.inventory.helpers.DeathStackHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryHandler
extends DeathStackHandler {
    private static final String MOD_ID = "vanilla";
    private InventoryPlayer inventoryPlayer;

    public InventoryHandler(EntityPlayer player) {
        super(player, MOD_ID);
        this.inventoryPlayer = player.field_71071_by;
        this.setSize(this.inventoryPlayer.func_70302_i_());
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return this.inventoryPlayer.func_70301_a(slot);
    }

    @Override
    public boolean checkToStore(int slot) {
        if (slot == this.inventoryPlayer.field_70461_c) {
            return InventoryModule.keepMainhand;
        }
        if (slot < 9) {
            return InventoryModule.keepHotbar;
        }
        if (slot >= 9 && slot < 36) {
            return InventoryModule.keepMainInventory;
        }
        if (slot >= 36 && slot < 40) {
            return InventoryModule.keepArmor;
        }
        if (slot == 40) {
            return InventoryModule.keepOffhand;
        }
        return false;
    }

    @Override
    public void retrieveInventory(IDeathInventory oldDeathInventory) {
        NBTTagCompound nbt = oldDeathInventory.getStorage(MOD_ID);
        if (nbt == null) {
            return;
        }
        this.storage.deserializeNBT(nbt);
        for (int slot = 0; slot < this.storage.getSlots(); ++slot) {
            ItemStack stack = this.storage.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            if (!this.inventoryPlayer.func_70301_a(slot).func_190926_b()) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)this.inventoryPlayer.field_70458_d, (ItemStack)stack);
                continue;
            }
            this.inventoryPlayer.func_70299_a(slot, stack);
        }
    }
}

